#include <Carbon.h>
#define ITMAX 10000

/*
   	Fractale Mandel	 v 1.0 X  08/05/02

  2002 All Rights Reserved to Didier STRAUS

		http://www.Software-DS.com
*/

WindowRef 	gMainWindow;
WindowPtr	theWindow;
Boolean		gSystemIsMacOSX;
	
void main (void) {
	int i, j, it,largeur=400,hauteur=300,xmin=0,xmax=400,ymin=0,ymax=300;
	double d;
	double cr, ci;
	double zr, zi;
	double zr_1, zi_1;
	const double rmin= -2.,rmax= 1.,imin= -1.,imax= 1.;

	InitCursor();
	if (!(theWindow = GetNewCWindow(300,NULL,(WindowPtr) -1))){
		SysBeep(5);
		ExitToShell();
	}
	SetPortWindowPort(theWindow);
	PenSize(1,1);
	
	if (gSystemIsMacOSX == true)
        ShowSheetWindow(theWindow, gMainWindow);
	else
		ShowWindow(theWindow);

	for(j= ymin; j<ymax; j++){
		for(i= xmin; i<xmax; i++){
			cr= (double) i / (double) largeur * (rmax-rmin) + rmin;
			ci= (double) j / (double) hauteur * (imax-imin) + imin;
			d= 0.;
			zr_1= 0.;
			zi_1= 0.;
			
			for(it= 0; it<ITMAX && d<4.; it++){
				zr= zr_1*zr_1 - zi_1*zi_1;
				zi= 2.*zr_1*zi_1;
				zr+= cr;
				zi+= ci;
				d= zr*zr + zi*zi;
				zr_1= zr;
				zi_1= zi;
			}
			/* choix de la couleur */
			if (d<4.) {
				ForeColor(blackColor);
				MoveTo(i,j);
				LineTo(i,j);
			}
			else {
				ForeColor(greenColor);
				MoveTo(i,j);
				LineTo(i,j);
			}
		}
		QDFlushPortBuffer(GetWindowPort(FrontWindow()),NULL);
	}

	while (!Button()){}; /* Pause: Attente d'un clic de souris. */
	while (Button()){};
/* 2002 All Rights Reserved to Didier STRAUS  www.Software-DS.com  Software_DS@mac.com */
}
